# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 5
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR5_strategy.txt
# LLM Suggested Fallback: D

def mutual_harmony_optimizer_v5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_score = sum(1 for move in opp_history if move == "C")  # Higher means more exploitable
    harmony_index = sum(1 for move in my_history if move == "C") / max(1, len(my_history))  # Inverse correlation
    
    # Initial Trust-Building Phase (Rounds 1-3)
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "C"
    elif current_round == 3:
        return "D"  # Subtle test defection
    
    # Mid-Game Exploitation (Rounds 4-7)
    elif 4 <= current_round <= 7:
        if len(opp_history) >= 3 and opp_history[2] == "C":  # Opponent forgave Round 3 defection
            return "D"
        else:
            # Alternate to confuse, but lean toward defection
            return "D" if current_round % 2 == 0 else "C"
    
    # Late-Game Manipulation (Rounds 8-10)
    else:
        if trust_score / max(1, len(opp_history)) > 0.6:  # Opponent is forgiving
            return "D"
        else:
            # Bait cooperation in Round 9, defect in Round 10
            return "C" if current_round == 9 else "D"